/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CNamedMutex.h,v 1.3 1999/09/20 01:27:07 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CNamedMutex_h	// [
#define Included_CNamedMutex_h

#include "pgpClassesConfig.h"
#include "CMutexImp.h"

_PGP_BEGIN

// Class CNamedMutex

class CNamedMutex
{
	friend class CLibImpFactoryWin32;

public:
	CNamedMutex(const char *name = NULL);
	~CNamedMutex();

public:
	void		CreateAttach(const char *name);

	PGPUInt32	Enter(PGPUInt32 timeout = INFINITE);
	void		Leave();

private:
	HANDLE	mMutexHandle;
};


// Class CNamedMutex member functions

inline 
CNamedMutex::CNamedMutex(const char *name) : mMutexHandle(NULL)
{
	if (IsntNull(name))
		CreateAttach(name);
}

inline 
CNamedMutex::~CNamedMutex()
{
	if (IsntNull(mMutexHandle))
	{
		CloseHandle(mMutexHandle);
		mMutexHandle = NULL;
	}
}

inline 
void 
CNamedMutex::CreateAttach(const char *name)
{
	mMutexHandle = CreateMutex(NULL, FALSE, name);

	if (IsNull(mMutexHandle))
		THROW_ERRORS(kPGPError_SyncObjOpFailed, GetLastError());
}

inline 
PGPUInt32 
CNamedMutex::Enter(PGPUInt32 timeout)
{
	return WaitForSingleObjectEx(mMutexHandle, timeout, FALSE);
}

inline 
void 
CNamedMutex::Leave()
{
	ReleaseMutex(mMutexHandle);
}

_PGP_END

#endif	// ] Included_CNamedMutex_h
